//
//  SimpleTableView.m
//  PopBio
//
//  Created by Stanislav Kounitski on 11/27/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import "SimpleTableView.h"

@implementation SimpleTableView

- (id)init
{
	self = [super init];
	if(self) {
		dataMatrix = [[NSMutableArray alloc] init];
		columns = nil;
	}
	return self;
}


- (void)rememberColumns
{
	columns = [NSArray arrayWithArray:[tableView tableColumns]];
}

- (void)setDataMatrix:(NSMutableArray*)aMatrix
{
	if(aMatrix == dataMatrix)
		return;

    if ([aMatrix isKindOfClass:[NSMutableArray class]]) {
        dataMatrix = aMatrix;
    } else if ([aMatrix isKindOfClass:[NSArray class]]) {
        dataMatrix = [aMatrix mutableCopy];
    } else {
        dataMatrix = nil;
    }
}

- (NSMutableArray*)dataMatrix
{
	return dataMatrix;
}

- (IBAction)addRow:(id)sender
{
	if(!dataMatrix)
		dataMatrix = [[NSMutableArray alloc] init];
	NSMutableArray *newRow = [delegate newRowForTable:tableView];
	[dataMatrix addObject:newRow];
	[tableView reloadData];
}

- (IBAction)removeSelectedRows:(id)sender
{
	[dataMatrix removeObjectsAtIndexes:[tableView selectedRowIndexes]];
	[delegate didRemoveRowsFromTable:tableView];
	[tableView reloadData];
}

- (NSData*)getData
{
	unsigned int rows = [dataMatrix count];
	unsigned int cols = [dataMatrix[0] count];
	NSMutableData *data = [NSMutableData data];
	[data appendBytes:&rows length:sizeof(unsigned int)];
	[data appendBytes:&cols length:sizeof(unsigned int)];
	
	int i, j;
	for(i=0; i<rows; i++) {
		for(j=0; j<cols; j++) {
			double entry = [dataMatrix[i][j] doubleValue];
			[data appendBytes:&entry length:sizeof(double)];
		}
	}
	
	return data;
}

- (void)setData:(NSData*)data
{
	unsigned int rows, cols;
	memcpy(&rows, [data bytes], sizeof(unsigned int));
	memcpy(&cols, [data bytes]+sizeof(unsigned int), sizeof(unsigned int));
	
	int i, j, offset = sizeof(unsigned int)*2;
	double entry;
	
	if(!dataMatrix)
		dataMatrix = [[NSMutableArray alloc] init];
	else
		[dataMatrix removeAllObjects];
	
	for(i=0; i<rows; i++) {
		NSMutableArray *row = [NSMutableArray array];
		[dataMatrix addObject:row];
	
		for(j=0; j<cols; j++) {
			memcpy(&entry, [data bytes]+offset, sizeof(double));
			[row addObject:@(entry)];
			offset += sizeof(double);
		}
	}
}

@end

@implementation SimpleTableView(NSTableViewDataSource)

- (int)numberOfRows
{
	return [dataMatrix count];
}

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	if(aTableView == tableView)
		return [dataMatrix count];
	return 0;
}

- (id)tableView:(NSTableView *) aTableView
	objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	if(aTableView != tableView)
		return nil;
	if(!columns)
		[self rememberColumns];
	int columnIndex = [columns indexOfObject:aTableColumn];
	return dataMatrix[rowIndex][columnIndex];
}

- (void)tableView:(NSTableView *)aTableView	setObjectValue:(id)anObject
  forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	if(aTableView != tableView)
		return;
	if(!columns)
		[self rememberColumns];
	int columnIndex = [columns indexOfObject:aTableColumn];
	dataMatrix[rowIndex][columnIndex] = anObject;
}

@end
