//
//  SimpleTableView.h
//  PopBio
//
//  Created by Stanislav Kounitski on 11/27/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import <Cocoa/Cocoa.h>

@interface SimpleTableView : NSView
{
	IBOutlet NSTableView *tableView;
	IBOutlet id delegate;
	NSMutableArray *dataMatrix;
	NSArray *columns;
}

- (void)rememberColumns;
- (void)setDataMatrix:(NSMutableArray*)aMatrix;
- (NSMutableArray*)dataMatrix;

- (NSData*)getData;
- (void)setData:(NSData*)data;

- (IBAction)addRow:(id)sender;
- (IBAction)removeSelectedRows:(id)sender;

@end

@interface SimpleTableView(NSTableViewDataSource)

- (int)numberOfRows;
- (int)numberOfRowsInTableView:(NSTableView *)aTableView;
- (id)tableView:(NSTableView *) aTableView
	objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;
- (void)tableView:(NSTableView *)aTableView	setObjectValue:(id)anObject
	forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;

@end

@interface NSObject(SimpleTableDataSourceDelegate)
- (void)didRemoveRowsFromTable:(NSTableView*)aTableView;
- (NSMutableArray *)newRowForTable:(NSTableView*)aTableView;
@end