/*
 *  RungeKutta.c
 *  PopBio
 *
 *  Created by Stanislav Kounitski on 10/18/07.
 *  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
 *
 */

#include "RungeKutta.h"

double getNextRungeKuttaValue(double x, double t, double (*xPrime)(double,double), double h)
{
	double k1, k2, k3, k4;
	
	k1 = xPrime(t,x);
	k2 = xPrime(t + h/2.0, x + h*k1/2.0);
	k3 = xPrime(t + h/2.0, x + h*k2/2.0);
	k4 = xPrime(t + h, x + h*k3);
	
	return x + (h/6.0)*(k1 + 2.0*k2 + 2.0*k3 + k4);
}

pair getNextRungeKuttaPairValue(pair x, double t, pair (*xPrime)(double,pair), double h)
{
	pair tmp, k1, k2, k3, k4;
	k1 = xPrime(t,x);
	
	tmp.a = x.a + h*k1.a/2.0;
	tmp.b = x.b + h*k1.b/2.0;
	k2 = xPrime(t + h/2.0, tmp);
	
	tmp.a = x.a + h*k2.a/2.0;
	tmp.b = x.b + h*k2.b/2.0;
	k3 = xPrime(t + h/2.0, tmp);
	
	tmp.a = x.a + h*k3.a;
	tmp.b = x.b + h*k3.b;
	k4 = xPrime(t + h, tmp);
	
	tmp.a = x.a + (h/6.0)*(k1.a + 2.0*k2.a + 2.0*k3.a + k4.a);
	tmp.b = x.b + (h/6.0)*(k1.b + 2.0*k2.b + 2.0*k3.b + k4.b);
	return tmp;
}
