//
//  PredatorPreyDocument.h
//  PopBio
//
//  Created by Aaron Golden on 05/09/07.
//  Copyright Reed College 2007. All rights reserved.
//

#import "PopBioDocument.h"
#import "Backend.h"
#import "PlotView.h"
@class PlotViewPointSelectorTool;
@class FineTunePanel;

@interface PredatorPreyDocument : PopBioDocument
{
	IBOutlet NSTabView *tabView;

	IBOutlet NSTextField *initialPreyPopulationTextField;
	IBOutlet NSTextField *initialPredatorPopulationTextField;
				
	IBOutlet NSTextField *LVTimeIntervalsTextField;
	IBOutlet NSTextField *LVPreyBirthRateTextField;
	IBOutlet NSTextField *LVPredatorDeathRateTextField;
	IBOutlet NSTextField *LVPredatorEnergyEfficiencyTextField;
	IBOutlet NSTextField *LVPreyCaptureProbabilityTextField;
	IBOutlet FineTunePanel *LVFineTunePanel;

	IBOutlet NSTextField *LesTimeIntervalsTextField;
	IBOutlet NSTextField *LesPreyBirthRateTextField;
	IBOutlet NSTextField *LesPredatorDeathRateTextField;
	IBOutlet NSTextField *LesPreyCaptureProbabilityTextField;
	IBOutlet NSTextField *LesCriticalPreyDensityTextField;
	IBOutlet NSTextField *LesPreyCarryingCapacityTextField;
	IBOutlet FineTunePanel *LesFineTunePanel;
	
	IBOutlet NSTextField *H1TimeIntervalsTextField;
	IBOutlet NSTextField *H1PreyBirthRateTextField;
	IBOutlet NSTextField *H1PredatorDeathRateTextField;
	IBOutlet NSTextField *H1PredatorEnergyEfficiencyTextField;
	IBOutlet NSTextField *H1PreyCaptureProbabilityTextField;
	IBOutlet NSTextField *H1PreyCarryingCapacityTextField;
	IBOutlet NSTextField *H1MaxPredatorAttackRateTextField;
	IBOutlet NSTextField *H1HalfAttackRateDensityTextField;
	IBOutlet FineTunePanel *H1FineTunePanel;
	
	IBOutlet NSTextField *H2TimeIntervalsTextField;
	IBOutlet NSTextField *H2PreyBirthRateTextField;
	IBOutlet NSTextField *H2PredatorDeathRateTextField;
	IBOutlet NSTextField *H2PredatorEnergyEfficiencyTextField;
	IBOutlet NSTextField *H2PreyCaptureProbabilityTextField;
	IBOutlet NSTextField *H2PreyCarryingCapacityTextField;
	IBOutlet NSTextField *H2MaxPredatorAttackRateTextField;
	IBOutlet NSTextField *H2HalfAttackRateDensityTextField;
	IBOutlet FineTunePanel *H2FineTunePanel;

	IBOutlet NSColorWell *predatorColorWell;
	IBOutlet NSColorWell *preyColorWell;

	int currentModel;

	PredatorPreyParameters LVParams;
	PredatorPreyParameters LesParams;
	PredatorPreyParameters H1Params;
	PredatorPreyParameters H2Params;
	
	NSImage *_crosshairImage;
	NSDictionary *_populationResults;
	NSString *_parametersReport;
	NSString *_resultsReport;
}

- (void)registerForNotifications;
- (void)updateTabs;

@end

@interface PredatorPreyDocument (NSTabViewDelegate)
- (void)tabView:(NSTabView *)tabView didSelectTabViewItem:(NSTabViewItem *)tabViewItem;
@end