/*
 *  PredatorPrey.h
 *  PopBio
 *
 *  Created by Aaron Golden on 05/09/07.
 *  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
 *
 */

#ifndef __PREDATOR_PREY__
#define __PREDATOR_PREY__

#include "IntegratorType.h"

typedef enum {
    ModelTypeLotkaVolterra,
    ModelTypeLeslie,
    ModelTypeHollingI,
    ModelTypeHollingII
} ModelType;

typedef struct ___PredatorPreyParameters{
	ModelType modelType;
	double timeIntervals;
	double initialPreyPopulation;
	double initialPredatorPopulation;
	double preyBirthRate;
	double predatorDeathRate;
	double predatorEnergyEfficiency;
	double preyCaptureProbability;
	double criticalPreyDensity;
	double preyCarryingCapacity;
	double maxPredatorAttackRate;
	double halfAttackRateDensity;
	double epsilon;
	IntegratorType integratorType;
	double pointStep;
	int randomSeed;
} PredatorPreyParameters;

int runPredatorPrey(int argc, char *argv[]);

#endif