//
//  PopGrowthDocument.h
//  PopBio
//
//  Created by Aaron Golden on 05/09/07.
//  Copyright Reed College 2007 . All rights reserved.
//


#import "PopBioDocument.h"
#import "Backend.h"
@class FineTunePanel;

@interface PopGrowthDocument : PopBioDocument
{
	IBOutlet NSTextField *timeIntervalsTextField;
	IBOutlet NSTextField *initialPopulationTextField;
	IBOutlet NSTextField *rateOfIncreaseTextField;
	IBOutlet NSTextField *growthTimeLagTextField;
	IBOutlet NSTextField *growthTimeLagLabel;
	IBOutlet NSTextField *carryingCapacityTextField;
	IBOutlet NSTextField *carryingCapacityLabel;
	IBOutlet NSTextField *numberOfTrialsTextField;
	IBOutlet NSMatrix *modelSelectionMatrix;
	IBOutlet NSButtonCell *exponentialButton;
	IBOutlet NSButtonCell *logisiticButton;
	IBOutlet NSButton *differenceEquationCheckBox;
	IBOutlet NSButton *timeToKCheckBox;
	
	IBOutlet NSTextField *rateOfIncreaseErrorTextField;
	IBOutlet NSTextField *carryingCapacityErrorTextField;
	IBOutlet NSPopUpButton *rateOfIncreaseErrorDistributionPopUpButton;
	IBOutlet NSPopUpButton *carryingCapacityErrorDistributionPopUpButton;
	
	IBOutlet NSWindow *multipleTrialsWindow;
	IBOutlet NSTableView *multipleTrialsResultsTable;
	IBOutlet NSPopUpButton *saveMenuPopUpButton;

	IBOutlet FineTunePanel *fineTunePanel;
	
	IBOutlet NSMatrix *stochasticDeterministicMatrix;
	IBOutlet NSButtonCell *deterministicButton;
	IBOutlet NSButtonCell *stochasticButton;	

	PopGrowthParameters params;
	
	NSDictionary *_populationResults;
	
	NSString *_parametersReport;
	NSString *_resultsReport;
}

- (IBAction)showMultipleTrialsWindow:(id)sender;
- (IBAction)saveMultipleTrialsTableAsText:(id)sender;

- (NSString *)parametersReport;
- (NSString*)resultsReportWithTimeIntervalsData:(NSArray*)timeIntervals populationData:(NSArray*)populationData;

- (int)doublingTimeInTrialIndex:(int)index;
- (double)finalPopulationInTrialIndex:(int)index;
- (double)finalTimeInTrialIndex:(int)index;

- (void)doGrowWindow;
- (NSDictionary*)parametersDictionary;
- (int)timeToKWithTimeIntervals:(NSArray*)timeIntervalsData andPopulationData:(NSArray*)populationData;

- (NSString*)titleForMultipleTrialsWindow;

@end

@interface PopGrowthDocument(NSWindowNotifications)
- (void)windowWillClose:(NSNotification *)notification;
@end
