/*
 *  PopGrowth.h
 *  PopBio
 *
 *  Created by Aaron Golden on 05/09/07.
 *  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
 *
 */

#ifndef __POPGROWTH__
#define __POPGROWTH__

#include "IntegratorType.h"

#define kModelTypeExponential 0
#define kModelTypeLogistic 1

#define kDistributionFixed 0
#define kDistributionUniform 1
#define kDistributionNormal 2

typedef struct ___PopGrowthParameters{
	double timeIntervals;
	double initialPopulation;
	double rateOfIncrease;
	double rateOfIncreaseErrorSize;
	int rateOfIncreaseErrorDistributionType;
	double growthTimeLag;
	double carryingCapacity;
	double carryingCapacityErrorSize;
	int carryingCapacityErrorDistributionType;
	int numberOfTrials;
	int differenceEquation;
	int timeToK;
	int multipleTrials;
	int modelType;
	IntegratorType integratorType;
	double pointStep;
	double epsilon;
	int randomSeed;
	
} PopGrowthParameters;

int runPopGrowth(int argc, char *argv[]);

#endif