/*
 *  PopGenetics.c
 *  PopBio
 *
 *  Created by Aaron Golden on 3/26/07.
 *  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
 *
 */
 
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "Backend.h"
#include "PopGenetics.h"

int runPopGenetics(int argc, char *argv[])
{
	if(argc < 12){
		printf("PopGen requires parameters:  <generations> <population size> <allele A frequency> <genotype AA fitness> <genotype Aa fitness> <genotype aa fitness> <number of trials> <multiple trials> <drift> <epsilon> <random seed>\n");
		return -1;
	}

	PopGenParameters params;
	sscanf(argv[2], "%d", &params.generations);
	sscanf(argv[3], "%d", &params.populationSize);
	sscanf(argv[4], "%lf", &params.alleleAFrequency);
	sscanf(argv[5], "%lf", &params.genotypeAAFitness);
	sscanf(argv[6], "%lf", &params.genotypeAaFitness);
	sscanf(argv[7], "%lf", &params.genotypeaaFitness);
	//sscanf(argv[8], "%lf", &params.inbreedingCoefficient);
	sscanf(argv[8], "%d", &params.numberOfTrials);
	sscanf(argv[9], "%d", &params.multipleTrials);
	sscanf(argv[10], "%d", &params.drift);
	sscanf(argv[11], "%lf", &params.epsilon);
	sscanf(argv[12], "%d", &params.randomSeed);
	
	srandom(params.randomSeed);
	
	if(!params.multipleTrials)
		params.numberOfTrials = 1;
		
	int trialNumber;
	for(trialNumber = 1; trialNumber <= params.numberOfTrials; trialNumber++){
		sscanf(argv[4], "%lf", &params.alleleAFrequency);
		
		printf("Genetics-Set\n");
		// Print a table header, tab separated list of
		// column titles.
		printf("Generations\tFrequency1\tFitness1\n");
		
		// Initialize these outside of the loop because
		// they are constant over the whole run.
		double w11 = params.genotypeAAFitness;
		double w12 = params.genotypeAaFitness;
		double w22 = params.genotypeaaFitness;
		//double F = params.inbreedingCoefficient;
		int j;
		for(j = 0; j <= params.generations; j++){	
			// We need to initialize these at every iteration.
			double p = params.alleleAFrequency;
			double q = 1.0 - p;
			double wbar = p*p*w11 + 2.0*p*q*w12 + q*q*w22;
			
			// Print the results so far (generation\tallele A frequency).
			printf("%d\t%.12f\t%.12f\n", j, params.alleleAFrequency, wbar);
			
			// If the frequency of allele A is within epsilon or 0 or 1
			// then we're done.
			if(params.alleleAFrequency < params.epsilon || 1.0 - params.alleleAFrequency < params.epsilon)
				break;
			
			params.alleleAFrequency += (p*q*(p*(w11-w12)+q*(w12-w22)))/wbar;
			// If stochastic drift is turned on, then compute the
			// drift and add that.
			if(params.drift){
				double U = _randomDouble();
				double N = params.populationSize;
				params.alleleAFrequency += (2.0*U-1.0)*sqrt(3.0*p*q/(2.0*N));
			}
		}
		
		printf("Fitness-Set\n");
		printf("Frequency2\tFitness2\n");
		double p;
		for(p = 0.0; p < 1.0; p += 0.01){
			double q = 1.0 - p;
			double wbar = p*p*w11 + 2.0*p*q*w12 + q*q*w22;
			printf("%.12f\t%.12f\n", p, wbar);
		}
		
		printf("TRIAL_DONE\n");
	}
	
	return 0;
}
