//
//  PopGenDocument.h
//  PopBio
//
//  Created by Aaron Golden on 3/23/07.
//  Copyright Reed College 2007 . All rights reserved.
//


#import "PopBioDocument.h"
#import "Backend.h"

@interface PopGenDocument : PopBioDocument
{
	IBOutlet NSTextField *generationsTextField;
	IBOutlet NSTextField *populationSizeLabel;
	IBOutlet NSTextField *populationSizeTextField;
	IBOutlet NSTextField *alleleAFrequencyTextField;
	IBOutlet NSTextField *genotypeAAFitnessLabel;
	IBOutlet NSTextField *genotypeAAFitnessTextField;
	IBOutlet NSTextField *genotypeAaFitnessLabel;
	IBOutlet NSTextField *genotypeAaFitnessTextField;
	IBOutlet NSTextField *genotypeaaFitnessLabel;
	IBOutlet NSTextField *genotypeaaFitnessTextField;
	//IBOutlet NSTextField *inbreedingCoefficientTextField;
	IBOutlet NSTextField *numberOfTrialsLabel;
	IBOutlet NSTextField *numberOfTrialsTextField;
	IBOutlet NSButton *driftCheckBox;
	IBOutlet NSBox *driftParamsBox;
	IBOutlet NSButton *selectionCheckBox;
	IBOutlet NSBox *selectionParamsBox;
	
	IBOutlet NSWindow *multipleTrialsWindow;
	IBOutlet NSTableView *multipleTrialsResultsTable;
	IBOutlet NSPopUpButton *saveMenuPopUpButton;

	PopGenParameters params;
	
	NSDictionary *_fitnessResults;
	NSDictionary *_geneticsResults;
	NSDictionary *_meanFitnessResults;
	
	NSString *_parametersReport;
	NSString *_resultsReport;
}

- (IBAction)selectionToggle:(id)sender;
- (IBAction)driftToggle:(id)sender;

- (IBAction)saveMultipleTrialsTableAsText:(id)sender;
- (IBAction)saveMultipleTrialsTableForLaTeX:(id)sender;
- (IBAction)showMultipleTrialsWindow:(id)sender;

- (NSDictionary*)geneticsResults;
- (NSDictionary*)fitnessResults;

- (NSString*)parametersReport;
- (NSString*)resultsReportWithGenerationsData:generationsData frequency1Data:frequency1Data fitness1Data:fitness1Data frequency2Data:frequency2Data fitness2Data:fitness2Data;

- (BOOL)lossInTrialIndex:(int)trialIndex;
- (BOOL)fixationInTrialIndex:(int)trialIndex;
- (int)timeToFixOrLossInTrialIndex:(int)trialIndex;

- (NSString*)titleForMultipleTrialsWindow;
- (NSDictionary*)parametersDictionary;

@end

@interface PopGenDocument(NSWindowNotifications)
- (void)windowWillClose:(NSNotification *)notification;
@end
