//
//  PopBioDocument.h
//  PopBio
//
//  Created by Aaron Golden on 3/26/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import <Cocoa/Cocoa.h>

@class PlotWindowController;

@interface PopBioDocument : NSDocument {
	NSTask *evaluator;
	NSPipe *toPipe;
	NSPipe *fromPipe;
	NSFileHandle *toEvaluator;
	NSFileHandle *fromEvaluator;
	
	NSString *parametersReport;
	NSMutableString *evaluatorOutput;
	NSMutableString *generatedPlotCode;
	NSString *fixedPlotCode;
	
	NSMutableArray *trials;
	
	NSWindowController *parametersWindowController;
	PlotWindowController *plotWindowController;
	BOOL hasPlotData;
	
	BOOL calculationInProgress;
	
	IBOutlet NSButton *calculateButton;
	IBOutlet NSProgressIndicator *progressIndicator;
}

// functions to be overriden by all subclasses:
- (void)synchronizeParamsToUserInterface;
- (void)synchronizeUserInterfaceToParams;
- (NSArray*)argumentsForEvaluator;
- (NSString *)parametersReport;
- (void)setPlotCodeStrings;
- (void)registerForNotifications;
- (NSString*)titleForPlotWindow;
- (IBAction)helpButton:(id)sender;

// functions common to all subclasses:
- (IBAction)synchronizeParametersAndUserInterface:(id)sender;
- (IBAction)beginCalculation:(id)sender;
- (void)finishCalculation;
- (void)gotData:(NSNotification*)notification;
- (void)setCalculationInProgress:(BOOL)calcInProgress;

// Provides access to the results from this
// document's latest run.
- (NSArray*)trials;

@end
