//
//  PopBioController.m
//  PopBio
//
//  Created by Aaron Golden on 4/2/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import "PopBioController.h"
#import "AccumulatorWindowController.h"

#import "PopGrowthDocument.h"
#import "PredatorPreyDocument.h"
#import "CompetitionDocument.h"
#import "PopGenDocument.h"
#import "LifeTableDocument.h"

@interface PopBioController(Private)
- (void)__newDocumentOfType:(NSString*)type;
@end

@implementation PopBioController(Private)
- (void)__newDocumentOfType:(NSString*)type
{
	NSError *err;
	NSDocument *doc = [[NSDocumentController sharedDocumentController] makeUntitledDocumentOfType:type error:&err];
	if(doc){
		[[NSDocumentController sharedDocumentController] addDocument:doc];
		[doc makeWindowControllers];
		[doc showWindows];
	}
	
	[startupWindow close];
}
@end

@implementation PopBioController(NSApplicationDelegate)

- (BOOL)applicationShouldOpenUntitledFile:(NSApplication *)sender
{
	return YES;
}

- (BOOL)applicationOpenUntitledFile:(NSApplication *)sender
{
	[startupWindow makeKeyAndOrderFront:self];
	return YES;
}

@end

@implementation PopBioController

- (void)applicationDidFinishLaunching:(NSNotification*)notification
{
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	
	if([defaults objectForKey:@"popGeneticsFixationLossThreshold"] == nil)
		[defaults setObject:@0.0001 forKey:@"popGeneticsFixationLossThreshold"];
	if([defaults objectForKey:@"popGeneticsStopOnFixationOrLoss"] == nil)
		[defaults setObject:@YES forKey:@"popGeneticsStopOnFixationOrLoss"];
	if([defaults objectForKey:@"verifyClosingAccumulator"] == nil)
		[defaults setObject:@YES forKey:@"verifyClosingAccumulator"];
	if([defaults objectForKey:@"popGrowthCapacityOrExtinctionThreshold"] == nil)
		[defaults setObject:@0.01 forKey:@"popGrowthCapacityOrExtinctionThreshold"];
	if([defaults objectForKey:@"competitionStabilityThreshold"] == nil)
		[defaults setObject:@0.01 forKey:@"competitionStabilityThreshold"];
}

- (IBAction)newPopGrowth:(id)sender    { [self __newDocumentOfType:@"Growth"]; }
- (IBAction)newPredatorPrey:(id)sender { [self __newDocumentOfType:@"PredatorPrey"]; }
- (IBAction)newPopGenetics:(id)sender  { [self __newDocumentOfType:@"PopBio Genetics"]; }
- (IBAction)newLifeTable:(id)sender    { [self __newDocumentOfType:@"LifeTable"]; }
- (IBAction)newCompetition:(id)sender  { [self __newDocumentOfType:@"Competition"]; }

- (void)accumulatorWindowWillClose:(NSNotification*)notification
{
	[showHideAccumulatorMenuItem setTitle:@"Show Accumulator"];
	[showHideAccumulatorMenuItem setAction:@selector(showAccumulator:)];
}

- (IBAction)showAccumulator:(id)sender
{
	if(!accumulatorWindowController) {
		accumulatorWindowController = [[AccumulatorWindowController alloc] initWithWindowNibName:@"Accumulator"];
		[[NSNotificationCenter defaultCenter] addObserver:self
			selector:@selector(accumulatorWindowWillClose:)
			name:NSWindowWillCloseNotification object:[accumulatorWindowController window]];
	}
	[accumulatorWindowController showWindow:nil];
	
	[showHideAccumulatorMenuItem setTitle:@"Hide Accumulator"];
	[showHideAccumulatorMenuItem setAction:@selector(hideAccumulator:)];
}

- (IBAction)hideAccumulator:(id)sender
{
	if(accumulatorWindowController)
		[[accumulatorWindowController window] orderOut:nil];
	
	[showHideAccumulatorMenuItem setTitle:@"Show Accumulator"];
	[showHideAccumulatorMenuItem setAction:@selector(showAccumulator:)];
}

- (BOOL)accumulatorHasPlot;
{
	return accumulatorWindowController && [accumulatorWindowController hasPlot];
}

- (BOOL)accumulatorHasCurve:(NSDictionary*)aCurve
{
	return accumulatorWindowController && [accumulatorWindowController hasCurve:aCurve];
}

- (void)addCurveToAccumulator:(NSDictionary*)aCurve withName:(NSString*)aName
{
	if(!accumulatorWindowController)
		[self showAccumulator:self];
	[accumulatorWindowController addCurve:aCurve withName:aName];	
}

- (void)setAccumulatorPlot: (NSDictionary*)aPlot
{
	if(!accumulatorWindowController)
		[self showAccumulator:self];
	[accumulatorWindowController setPlot:aPlot];
}

- (IBAction)showHelp:(id)sender
{
	[self openHelp:self];
}

- (void)openHelp:(id)sender
{
	NSString *pathForHelpDoc = [[NSBundle bundleForClass:[self class]] pathForResource:@"manual" ofType:@"pdf"];
	PDFDocument *helpDoc = [[PDFDocument alloc] initWithURL:[NSURL fileURLWithPath:pathForHelpDoc]];
	if(![helpPDFView document]) {
		[helpPDFView setDocument:helpDoc];
		[helpPDFView setAutoScales:YES];
	}
	
	int pageIndex;
	NSPoint thePoint = NSMakePoint(0,792);
	if([sender isKindOfClass:[PopGrowthDocument class]]){
		pageIndex = kPopGrowthStartPageIndex;
	}
	else if([sender isKindOfClass:[PredatorPreyDocument class]]){
		pageIndex = kPredatorPreyStartPageIndex;
	}
	else if([sender  isKindOfClass:[PopGenDocument class]]){
		pageIndex = kPopGenStartPageIndex;
	}
	else if([sender isKindOfClass:[LifeTableDocument class]]){
		pageIndex = kLifeTableStartPageIndex;
	}
	else if([sender isKindOfClass:[CompetitionDocument class]]){
		pageIndex = kCompetitionStartPageIndex;
	}
	else{
		pageIndex = kFirstPageIndex;
	}
	PDFPage *thePage = [helpDoc pageAtIndex:pageIndex];
	[helpPDFView goToDestination:[[PDFDestination alloc] initWithPage:thePage atPoint:thePoint]];
	
	[helpWindow makeKeyAndOrderFront:nil];
}

- (NSNumber*)nextCurveID
{
	static unsigned long long curveID = 0;
	if(curveID == 0)
		curveID = time(0);
	return @(curveID++);
}

@end