//
//  PopBioController.h
//  PopBio
//
//  Created by Aaron Golden on 4/2/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import <Cocoa/Cocoa.h>
#import <Quartz/Quartz.h>

#define PBController (PopBioController*)[[NSApplication sharedApplication] delegate]

#define kFirstPageIndex 0
#define kPopGrowthStartPageIndex 1
#define kPredatorPreyStartPageIndex 2
#define kPopGenStartPageIndex 3
#define kLifeTableStartPageIndex 4
#define kCompetitionStartPageIndex 5

@class AccumulatorWindowController;

@interface PopBioController : NSObject
{
	IBOutlet NSMenuItem *showHideAccumulatorMenuItem;
	IBOutlet NSWindow *startupWindow;
	
	IBOutlet NSWindow *helpWindow;
	IBOutlet PDFView *helpPDFView;
	IBOutlet NSOutlineView *helpOutlineView;
	
	AccumulatorWindowController *accumulatorWindowController;
}

- (IBAction)newPopGrowth:(id)sender;
- (IBAction)newPredatorPrey:(id)sender;
- (IBAction)newPopGenetics:(id)sender;
- (IBAction)newLifeTable:(id)sender;
- (IBAction)newCompetition:(id)sender;

- (IBAction)showAccumulator:(id)sender;
- (IBAction)hideAccumulator:(id)sender;

- (void)setAccumulatorPlot: (NSDictionary*)aPlot;
- (BOOL)accumulatorHasPlot;
- (void)addCurveToAccumulator:(NSDictionary*)aCurve withName:(NSString*)aName;
- (BOOL)accumulatorHasCurve:(NSDictionary*)aCurve;

- (IBAction)showHelp:(id)sender;
- (void)openHelp:(id)sender;

- (NSNumber*)nextCurveID;

@end