//
//  PlotWindowController.m
//  PopBio
//
//  Created by Aaron Golden on 3/24/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import "PlotWindowController.h"
#import "PopBioController.h"
#import "PlotView.h"
#import "parsePlotCode.h"
#import "AgeStructureView.h"
#import "SimpleTableView.h"

@interface PlotWindowController(Private)
- (void)__synchronizeUserInterface;
- (void)__launchAskForNamePanel;
@end

@implementation PlotWindowController(Private)

- (void)__synchronizeUserInterface
{	
	BOOL graphicalPlot = NO;
	NSView *theView = nil;

	[ageStructureView setHidden:YES];
	[lifeTableResultsView setHidden:YES];
	
	if(plots && [plots count] > 0){				
		_selectedPlot = plots[[plotsPopUpButton indexOfSelectedItem]];
		
		NSString *customViewString = _selectedPlot[@"custom-view"];
		
		if(customViewString) {
			NSView *customView = nil;
			
			if([customViewString isEqualToString:@"Age Structure View"]) {
				customView = ageStructureView;
				[ageStructureView setResultsMatrix:_selectedPlot[@"data-matrix"]];
			} else if([customViewString isEqualToString:@"Simple Table View"]) {
				customView = lifeTableResultsView;
				[lifeTableResultsView setDataMatrix:_selectedPlot[@"data-matrix"]];
			}
			
			[plotView setHidden:YES];
			[customView setHidden:NO];
			NSRect plotViewFrame = [plotView frame];
			NSRect plotViewBounds = [plotView bounds];
			[[[plotView window] contentView] addSubview:customView];
			[customView setFrame:plotViewFrame];
			[customView setBounds:plotViewBounds];
			[[[plotView window] contentView] setNeedsDisplay:YES];
			
			if(![customView isKindOfClass:[PlotView class]])
				graphicalPlot = NO;
				
			theView = customView;
			
			// ------------------------------------------------------------
		}
		else {
			graphicalPlot = YES;
			[plotView setHidden:NO];
			[plotView displayPlot:_selectedPlot];
			
			theView = plotView;
		}
		NSString *commentString = _selectedPlot[@"comment"];
		if(!commentString)
			commentString = @"";
		[commentTextField setStringValue:commentString];
	}
	else{
		[plotView displayPlot:nil];
		[commentTextField setStringValue:@""];
	}
	
	[savePlotAsTIFFMenuItem setTarget:theView];
	[savePlotAsPDFMenuItem setTarget:theView];
	
	[gridToggleButton setEnabled:graphicalPlot];
	[plotEditButton setEnabled:graphicalPlot];
	//[zoomOutButton setEnabled:graphicalPlot];
	//[zoomAllTheWayOutButton setEnabled:graphicalPlot];
	[twoXButton setEnabled:graphicalPlot];
	[halfXButton setEnabled:graphicalPlot];
	[twoYButton setEnabled:graphicalPlot];
	[halfYButton setEnabled:graphicalPlot];
	[logLinearButton setEnabled:graphicalPlot];
	[addToAccumulatorButton setEnabled:graphicalPlot];
}

- (void)__launchAskForNamePanel
{
	NSString *curveName = _selectedCurve[@"title"];
	if(!curveName)
		curveName = _selectedPlot[@"long-title"];
	[nameTextField setStringValue:curveName];
	[NSApp beginSheet:askForNamePanel modalForWindow:[self window]
		modalDelegate:nil didEndSelector:nil contextInfo:nil];
	[NSApp runModalForWindow:askForNamePanel];
}
@end

@implementation PlotWindowController

- (id)initWithWindow:(NSWindow *)window
{
	self = [super initWithWindow:window];
	if(!self)
		return nil;
	[self setPlots:nil];
	return self;
}

- (IBAction)selectPlot:(id)sender
{
	[self __synchronizeUserInterface];
}

- (void)setPlotCode:(NSArray*)stringArray
{
	// save the new strings
	plotCodeStrings = stringArray;

	// parse the results and configuration strings to generate the plot data
	int i;
	NSMutableDictionary *dict = [NSMutableDictionary dictionary];
	for(i=0; i<[plotCodeStrings count]; i++)
		parsePlotCode(plotCodeStrings[i], dict);

	NSMutableArray *newPlots = dict[@"plots"];
	
	// The first element of the plotCodeStrings will be the code returned
	// by the evaluator, so we'll set that to be the results string
	for(i=0; i<[newPlots count]; i++) {
		NSMutableDictionary *currentPlot = newPlots[i];
		
		if(!currentPlot[@"results-report"])
			currentPlot[@"results-report"] = plotCodeStrings[0];
	}
	
	// save the new plots
	[self setPlots:newPlots];
}

- (void)setPlots:(NSArray*)somePlots
{
	// Save off the index of the currently selected plot, so that
	// the user doesn't have to keep switching back if they rerun
	// the experiment.
	int selectedPlotIndex = [plotsPopUpButton indexOfSelectedItem];

	plots = somePlots;
	[plotsPopUpButton removeAllItems];
	
	if(plots) {
		int j;
		for(j = 0; j < [plots count]; j++){
			[plotsPopUpButton addItemWithTitle:plots[j][@"short-title"]];
		}
		
		[plotsPopUpButton selectItemAtIndex:selectedPlotIndex];
	}
	
	[self __synchronizeUserInterface];
}

- (NSView*)plotView
{
	return plotView;
}

- (IBAction)addSelectedPlotToAccumulator:(id)sender
{
	PopBioController *appController = PBController;
		
	if(![appController accumulatorHasPlot])
		[appController setAccumulatorPlot:_selectedPlot];
	
	NSArray *curves = _selectedPlot[@"curves"];
	
	int i;
	for(i=0; i<[curves count]; i++) {
		_selectedCurve = curves[i];
		if(![appController accumulatorHasCurve:_selectedCurve])
			[self __launchAskForNamePanel];
	}

	[appController showAccumulator:self];
}

- (IBAction)confirmNameAndCloseDialog:(id)sender
{
	NSString *curveName = [nameTextField stringValue];
	
	[NSApp stopModal];
	[NSApp endSheet:askForNamePanel];
	[askForNamePanel orderOut:self];
	
	PopBioController *appController = PBController;
	[appController addCurveToAccumulator:_selectedCurve withName:curveName];
}

- (IBAction)cancelAndCloseDialog:(id)sender
{
	[NSApp stopModal];
	[NSApp endSheet:askForNamePanel];
	[askForNamePanel orderOut:self];
}

- (NSPopUpButton*)saveOptionsPopUpButton
{
	return saveOptionsPopUpButton;
}

- (void)saveString:(NSString*)aString toFileWithDefaultName:(NSString*)defaultFilename
{
	NSSavePanel *sp = [NSSavePanel savePanel];
	[sp setAllowedFileTypes:@[@"txt"]];
    [sp setDirectoryURL:nil];
    [sp setNameFieldStringValue:defaultFilename];
    int runResult = [sp runModal];
	if (runResult == NSOKButton) {
        NSError *writeError = nil;
		if (![aString writeToURL:[sp URL] atomically:YES encoding:NSUTF8StringEncoding error:&writeError]){
			[[NSAlert alertWithMessageText:@"An error occurred while saving."
				defaultButton:@"OK" alternateButton:nil otherButton:nil
				informativeTextWithFormat:@"An error occurred while attempting to save the parameters: %@", [writeError localizedDescription]]
				beginSheetModalForWindow:[self window] modalDelegate:nil didEndSelector:nil contextInfo:nil];
		}
	}
}

- (IBAction)saveParametersAsText:(id)sender
{
	NSString *parametersString = _selectedPlot[@"parameters-report"];
	if(parametersString)
		[self saveString:parametersString toFileWithDefaultName:@"Untitled Parameters"];
	[saveOptionsPopUpButton selectItemAtIndex:0];
}

- (IBAction)saveResultsAsText:(id)sender
{
	NSString *resultsString = _selectedPlot[@"results-report"];
	if(resultsString)
		[self saveString:resultsString toFileWithDefaultName:@"Untitled Results"];
	[saveOptionsPopUpButton selectItemAtIndex:0];
}

@end
