//
//  PlotWindowController.h
//  PopBio
//
//  Created by Aaron Golden on 3/24/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import <Cocoa/Cocoa.h>

@class PlotView;
@class AgeStructureView;
@class SimpleTableView;

@interface PlotWindowController : NSWindowController {
	NSArray *plotCodeStrings;

	NSArray *plots;
	
	NSDictionary *_selectedPlot;
	NSDictionary *_selectedCurve;
	
	IBOutlet AgeStructureView *ageStructureView;
	IBOutlet SimpleTableView *lifeTableResultsView;
	
	IBOutlet NSTextField *commentTextField;
	IBOutlet NSPopUpButton *plotsPopUpButton;
	IBOutlet PlotView *plotView;
	
	IBOutlet NSPanel *askForNamePanel;
	IBOutlet NSTextField *nameTextField;
	IBOutlet NSTextField *askForNameLabel;
	
	IBOutlet NSPopUpButton *saveOptionsPopUpButton;	
	IBOutlet NSMenuItem *savePlotAsTIFFMenuItem;
	IBOutlet NSMenuItem *savePlotAsPDFMenuItem;
	IBOutlet NSMenuItem *saveParametersAsTextMenuItem;
	IBOutlet NSMenuItem *saveResultsAsTextMenuItem;
	
	IBOutlet NSButton *gridToggleButton;
	IBOutlet NSButton *plotEditButton;
	IBOutlet NSButton *zoomOutButton;
	IBOutlet NSButton *zoomAllTheWayOutButton;
	IBOutlet NSButton *twoXButton;
	IBOutlet NSButton *halfXButton;
	IBOutlet NSButton *twoYButton;
	IBOutlet NSButton *halfYButton;
	IBOutlet NSButton *logLinearButton;
	IBOutlet NSButton *addToAccumulatorButton;
}

- (void)setPlotCode:(NSArray*)stringArray;
- (void)setPlots:(NSArray*)somePlots;
- (IBAction)selectPlot:(id)sender;

- (NSView*)plotView;

- (IBAction)addSelectedPlotToAccumulator:(id)sender;
- (IBAction)confirmNameAndCloseDialog:(id)sender;
- (IBAction)cancelAndCloseDialog:(id)sender;

- (IBAction)saveParametersAsText:(id)sender;
- (IBAction)saveResultsAsText:(id)sender;

- (NSPopUpButton*)saveOptionsPopUpButton;

@end
