//
//  PlotViewZoomTool.h
//  PopBio
//
//  Created by Stanislav Kounitski on 10/17/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import <Cocoa/Cocoa.h>
@class PlotView;

@interface PlotViewZoomTool : NSObject
{
	// In pixel space
	NSRect _zoomRect;
	NSPoint _zoomRectStartPoint;
	NSPoint _zoomRectEndPoint;
	
	// in data space
	NSMutableArray *_viewRectStack;
	
	BOOL _animateZooming;
	BOOL _mouseIsBeingDragged;
	BOOL _mouseControlsDisabled;
	
	IBOutlet PlotView *_plotView;
	IBOutlet NSButton *_unzoomButton;
	IBOutlet NSButton *_zoomOutButton;
}

- (id)init;
- (void)zoomToRect:(NSRect)zoomRect;
- (void)graphicallyZoomToRect:(NSRect)targetRect;

- (IBAction)unzoom:(id)sender;
- (IBAction)zoomOut:(id)sender;
- (IBAction)doubleXAxis:(id)sender;
- (IBAction)halfXAxis:(id)sender;
- (IBAction)doubleYAxis:(id)sender;
- (IBAction)halfYAxis:(id)sender;

@end

@interface PlotViewZoomTool (PlotViewMouseDelegate)

- (NSCursor*)cursorForPlotView;
- (void)mouseDownAtPoint:(NSPoint)pixelPoint;
- (void)mouseDraggedAtPoint:(NSPoint)pixelPoint;
- (void)mouseUpAtPoint:(NSPoint)pixelPoint;
- (void)dataRectHasChanged;

@end