//
//  PlotViewZoomAnimation.m
//  PopBio
//
//  Created by Stanislav Kounitski on 10/17/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import "PlotViewZoomAnimation.h"
#import "PlotView.h"

@implementation PlotViewZoomAnimation

- (id)initWithDuration:(NSTimeInterval)duration animationCurve:(NSAnimationCurve)curve
	plotView:(PlotView*)pv initialRect:(NSRect)rect1 finalRect:(NSRect)rect2
{
	self = [super initWithDuration:duration animationCurve:curve];
    if (self) {
        plotView = pv;
        initialRect = rect1;
        finalRect = rect2;
    }
	return self;
}

- (void)setCurrentProgress:(NSAnimationProgress)progress
{
    [super setCurrentProgress:progress];

	double x0 = (1.0-progress)*NSMinX(initialRect) + progress*NSMinX(finalRect);
	double y0 = (1.0-progress)*NSMinY(initialRect) + progress*NSMinY(finalRect);
	double x1 = (1.0-progress)*NSMaxX(initialRect) + progress*NSMaxX(finalRect);
	double y1 = (1.0-progress)*NSMaxY(initialRect) + progress*NSMaxY(finalRect);
	
	[plotView setViewRect:NSMakeRect(x0, y0, x1-x0, y1-y0)];
	[plotView setNeedsDisplay:YES];
 }

@end
