//
//  PlotViewPointSelectorTool.m
//  PopBio
//
//  Created by Stanislav Kounitski on 10/17/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import "PlotViewPointSelectorTool.h"
#import "PlotView.h"
#import "CompetitionDocument.h"

@implementation PlotViewPointSelectorTool

- (id)init
{
	self = [super init];
    if (self) {
        NSString *str = [[NSBundle bundleForClass:[self class]] pathForImageResource:@"targetCursor.png"];
        NSImage *cursorImage = [[NSImage alloc] initWithContentsOfFile:str];
        selectorCursor = [[NSCursor alloc] initWithImage:cursorImage hotSpot:NSMakePoint(8,8)];
    }
	return self;
}


@end

@implementation PlotViewPointSelectorTool (PlotViewMouseDelegate)

- (NSCursor*)cursorForPlotView
{
	return selectorCursor;
}

- (void)mouseDownAtPoint:(NSPoint)pixelPoint;
{
	NSPoint dataPoint = [plotView dataPointFromPixelPoint:pixelPoint];
	NSRect viewRect = [plotView viewRect];
	dataPoint.x = MAX(dataPoint.x, NSMinX(viewRect));
	dataPoint.y = MAX(dataPoint.y, NSMinY(viewRect));
	dataPoint.x = MIN(dataPoint.x, NSMaxX(viewRect));
	dataPoint.y = MIN(dataPoint.y, NSMaxY(viewRect));
	if(parent != nil)
		[parent mouseDownAtDataPoint:dataPoint];
}

- (void)mouseDraggedAtPoint:(NSPoint)pixelPoint;
{
	[self mouseDownAtPoint:pixelPoint];
}

- (void)dataRectHasChanged
{
	[plotView setViewRect:[plotView dataRect]];
}

@end