//
//  NSDictionaryCurve.m
//  PopBio
//
//  Created by Stanislav Kounitski on 10/16/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import "NSDictionaryCurve.h"
#import "PopBioController.h"

@implementation NSDictionary(Curve)

+ (NSDictionary*)curveWithX:(NSArray*)xData Y:(NSArray*)yData
{
	return @{@"x-data": xData,
            @"y-data": yData,
            @"curve-id": [PBController nextCurveID]};
}

+ (NSDictionary*)curveWithX:(NSArray*)xData Y:(NSArray*)yData color:(NSColor*)color
{
	return @{@"x-data": xData,
            @"y-data": yData,
            @"color": color,
            @"curve-id": [PBController nextCurveID]};
}

+ (NSDictionary*)curveWithX:(NSArray*)xData Y:(NSArray*)yData color:(NSColor*)color title:(NSString*)title
{
	return @{@"x-data": xData,
            @"y-data": yData,
            @"color": color,
            @"title": title,
            @"curve-id": [PBController nextCurveID]};
}

+ (NSDictionary*)lineWithSlope:(double)m intercept:(double)b
{
	return @{@"special-curve": @"line",
            @"slope": @(m),
            @"y-intercept": @(b),
            @"curve-id": [PBController nextCurveID]};
}

+ (NSDictionary*)lineWithSlope:(double)m intercept:(double)b color:(NSColor*)color
{
	return @{@"special-curve": @"line",
            @"slope": @(m),
            @"y-intercept": @(b),
            @"color": color,
            @"curve-id": [PBController nextCurveID]};
}

+ (NSDictionary*)lineWithSlope:(double)m intercept:(double)b color:(NSColor*)color title:(NSString*)title
{
	return @{@"special-curve": @"line",
            @"slope": @(m),
            @"y-intercept": @(b),
            @"color": color,
            @"title": title,
            @"curve-id": [PBController nextCurveID]};
}

+ (NSDictionary*)vLineWithX:(double)x color:(NSColor*)color title:(NSString*)title
{
	return @{@"special-curve": @"vLine",
            @"x": @(x),
            @"color": color,
            @"title": title,
            @"curve-id": [PBController nextCurveID]};
}

+ (NSDictionary*)imageWithImage:(NSImage*)img X:(double)x Y:(double)y
	xOffset:(double)xOffset yOffset:(double)yOffset opacity:(double)opacity
{
	return @{@"special-curve": @"image",
            @"image": img,
            @"x": @(x),
            @"y": @(y),
            @"x-offset": @(xOffset),
            @"y-offset": @(yOffset),
            @"opacity": @(opacity),
            @"curve-id": [PBController nextCurveID]};
}

- (BOOL)isEqualToCurve:(NSDictionary*)otherCurve;
{
	NSString *str1 = [self summaryOfCurve];
	NSString *str2 = [otherCurve summaryOfCurve];
	return [str1 isEqualToString:str2];
}

- (NSString*)summaryOfCurve;
{
	NSString *str = self[@"special-curve"];
	
	if(str==nil) {
		if(!self[@"curve-id"])
			return @"Not a curve";
		NSString *title = self[@"title"];
		unsigned long long curveID = [self[@"curve-id"] unsignedLongLongValue];
		if(!title)
			return [NSString stringWithFormat:@"Unnamed curve (id = %llu)", curveID];
		else
			return [NSString stringWithFormat:@"Curve: \"%@\" (id = %llu)", title, curveID];
			
	}
	else if([str isEqualToString:@"line"]) {
		NSString *title = self[@"title"];
		double m = [self[@"slope"] doubleValue];
		double b = [self[@"intercept"] doubleValue];
		if(title)
			return [NSString stringWithFormat:@"Line: \"%@\" (y = %.3f*x%+.3f)", title, m, b];
		else
			return [NSString stringWithFormat:@"Unnamed line (y = %.3f*x%+.3f)", m, b];
	}
	else if([str isEqualToString:@"image"]) {
		NSString *title = self[@"title"];
		double x = [self[@"x"] doubleValue];
		double y = [self[@"y"] doubleValue];
		if(title)
			return [NSString stringWithFormat:@"Image: \"%@\" (x=%.3f, y=%.3f)", title, x, y];
		else
			return [NSString stringWithFormat:@"Unnamed image (x=%.3f, y=%.3f)", x, y];
	}
	
	return [NSString stringWithFormat:@"Unrecognized special curve: %@", str];
}

@end
