//
//  NSDictionaryCurve.h
//  PopBio
//
//  Created by Stanislav Kounitski on 10/16/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import <Cocoa/Cocoa.h>

@interface NSDictionary(Curve)

+ (NSDictionary*)curveWithX:(NSArray*)xData Y:(NSArray*)yData;
+ (NSDictionary*)curveWithX:(NSArray*)xData Y:(NSArray*)yData color:(NSColor*)color;
+ (NSDictionary*)curveWithX:(NSArray*)xData Y:(NSArray*)yData color:(NSColor*)color title:(NSString*)title;
+ (NSDictionary*)lineWithSlope:(double)m intercept:(double)b;
+ (NSDictionary*)lineWithSlope:(double)m intercept:(double)b color:(NSColor*)color;
+ (NSDictionary*)lineWithSlope:(double)m intercept:(double)b color:(NSColor*)color title:(NSString*)title;
+ (NSDictionary*)vLineWithX:(double)x color:(NSColor*)color title:(NSString*)title;
+ (NSDictionary*)imageWithImage:(NSImage*)img X:(double)x Y:(double)y
	xOffset:(double)xOffset yOffset:(double)yOffset opacity:(double)opacity;

- (BOOL)isEqualToCurve:(NSDictionary*)otherCurve;
- (NSString*)summaryOfCurve;

@end
