//
//  NSColorAdditions.m
//  PopBio
//
//  Created by Stanislav Kounitski on 11/26/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import "NSColorAdditions.h"
#import "stdio.h"

@implementation NSColor(String)

- (NSString*)stringValue
{
	unsigned int r = (unsigned int)round([self redComponent]*255.0);
	unsigned int g = (unsigned int)round([self greenComponent]*255.0);
	unsigned int b = (unsigned int)round([self blueComponent]*255.0);
	
	return [NSString stringWithFormat:@"#%02x%02x%02x", r, g, b];
}

+ (NSColor*)colorWithString:(NSString*)aString
{
	if([aString length] != 7 || [aString characterAtIndex:0] != '#')
		return [NSColor blackColor];

	unsigned int r=0, g=0, b=0;

	sscanf([[aString substringWithRange:NSMakeRange(1,2)] UTF8String], "%x", &r);
	sscanf([[aString substringWithRange:NSMakeRange(3,2)] UTF8String], "%x", &g);
	sscanf([[aString substringWithRange:NSMakeRange(5,2)] UTF8String], "%x", &b);
	
	double R = (double)r / 255.0, G = (double)g / 255.0, B = (double)b / 255.0;
	return [NSColor colorWithCalibratedRed:R green:G blue:B alpha:1.0];
}

@end