//
//  MyPDFView.m
//  PopBio
//
//  Created by Stanislav Kounitski on 1/16/08.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import "MyPDFView.h"


@implementation MyPDFView

- (id)init
{
	self = [super init];
	if(self)
		root = nil;
	return self;
}


- (void)setDocument:(PDFDocument *)document
{
	[super setDocument:document];
	root = [document outlineRoot];
	
	// I'm SURE there's a better way to do this than to add oneself as one's observer...
	[[NSNotificationCenter defaultCenter] addObserver:self selector: @selector(pageChanged:) 
		name:PDFViewPageChangedNotification object:self];
	
	[outlineView reloadData];
	[outlineView expandItem:root expandChildren:YES]; // doesn't work... why?
}

- (IBAction)takeDestinationFromOutline:(id)sender
{
	[self goToDestination: [[sender itemAtRow: [sender selectedRow]] destination]];
}

- (void)pageChanged:(NSNotification *)notification
{
	unsigned int	newPageIndex;
	int				numRows;
	int				i;
	int				newlySelectedRow;
	
	// Skip out if there is no outline or no delegate.
	if (!root || !outlineView)
		return;
	
	// What is the new page number (zero-based).
	newPageIndex = [[self document] indexForPage: [self currentPage]];
	
	// Walk outline view looking for best firstpage number match.
	newlySelectedRow = -1;
	numRows = [outlineView numberOfRows];
	for (i = 0; i < numRows; i++)
	{
		PDFOutline	*outlineItem;
		
		// Get the destination of the given row....
		outlineItem = (PDFOutline *)[outlineView itemAtRow:i];
		
		if ([[self document] indexForPage: [[outlineItem destination] page]] == newPageIndex)
		{
			newlySelectedRow = i;
            [outlineView selectRowIndexes:[NSIndexSet indexSetWithIndex:newlySelectedRow] byExtendingSelection:NO];
			break;
		}
		else if ([[self document] indexForPage: [[outlineItem destination] page]] > newPageIndex)
		{
			newlySelectedRow = i - 1;
            [outlineView selectRowIndexes:[NSIndexSet indexSetWithIndex:newlySelectedRow] byExtendingSelection:NO];
			break;
		}
	}
	
	// Auto-scroll.
	if (newlySelectedRow != -1)
		[outlineView scrollRowToVisible: newlySelectedRow];
}

@end

@implementation MyPDFView(NSOutlineViewDelegate)

- (NSInteger)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item
{
	if (item == nil)
		return (root ? [root numberOfChildren] : 0);
	return [(PDFOutline *)item numberOfChildren];
}

- (id)outlineView:(NSOutlineView *)outlineView child:(NSInteger)index ofItem:(id)item
{
	if (item == nil)
		return (root ? [root childAtIndex: index] : nil);
	return [(PDFOutline *)item childAtIndex: index];
}

- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item
{
	if(item == nil)
		return (root ? [root numberOfChildren] > 0 : NO);
	return ([(PDFOutline *)item numberOfChildren] > 0);
}

- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item
{
    return [(PDFOutline *)item label];
}

@end