#import "LifeTableView.h"

@implementation LifeTableView

- (BOOL)isStochastic
{
	return stochastic;
}

- (void)setIsStochastic:(BOOL)yesOrNo;
{
	if(stochastic != yesOrNo){
		stochastic = yesOrNo;
		if(stochastic)
		{
			[self addTableColumn:pxerr];
			[self addTableColumn:mxerr];
			[self moveColumn:4 toColumn:3];
		}
		else
		{
			[self removeTableColumn:pxerr];
			[self removeTableColumn:mxerr];
		}
		[self reloadData];
		[self sizeToFit];
		[self setNeedsDisplay:YES];
	}
}

@end

@implementation LifeTableView (NSNibAwaking)

- (void)awakeFromNib
{
	NSArray *columnArray = [self tableColumns];
	int i;
	for(i=0; i<6; i++)
		[[columnArray objectAtIndex:i] setIdentifier:[NSNumber numberWithInt:i]];
	
	pxerr = [columnArray objectAtIndex:3];
	mxerr = [columnArray objectAtIndex:5];
	[pxerr retain];
	[mxerr retain];
	[self removeTableColumn:pxerr];
	[self removeTableColumn:mxerr];
	[self sizeToFit];
}
@end