//
//  LifeTableResultsView.m
//  PopBio
//
//  Created by Aaron Golden on 8/1/07.
//  Copyright 2007 Reed College. All rights reserved.
//

#import "LifeTableResultsView.h"


@implementation LifeTableResultsView

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
		parametersString = [[NSMutableString alloc] init];
		resultsString = [[NSMutableString alloc] init];
    }
    return self;
}

- (IBAction)saveParametersAsText:(id)sender
{
	NSString *defaultFilename = @"Untitled Parameters";
	NSSavePanel *sp = [NSSavePanel savePanel];
	[sp setRequiredFileType:@"txt"];
	int runResult = [sp runModalForDirectory:nil file:defaultFilename];
	if (runResult == NSOKButton) {
		if (![parametersString writeToFile:[sp filename] atomically:YES]){
			[[NSAlert alertWithMessageText:@"An error occurred while saving."
				defaultButton:@"OK" alternateButton:nil otherButton:nil
				informativeTextWithFormat:@"An error occurred while attempting to save the parameters."]
				beginSheetModalForWindow:[self window] modalDelegate:nil didEndSelector:nil contextInfo:nil];
		}
	}
	
	[popUpButton selectItemAtIndex:0];
}

- (IBAction)saveResultsAsText:(id)sender
{
	NSString *defaultFilename = @"Untitled Results";
	NSSavePanel *sp = [NSSavePanel savePanel];
	[sp setRequiredFileType:@"txt"];
	int runResult = [sp runModalForDirectory:nil file:defaultFilename];
	if (runResult == NSOKButton) {
		if (![resultsString writeToFile:[sp filename] atomically:YES]){
			[[NSAlert alertWithMessageText:@"An error occurred while saving."
				defaultButton:@"OK" alternateButton:nil otherButton:nil
				informativeTextWithFormat:@"An error occurred while attempting to save the results."]
				beginSheetModalForWindow:[self window] modalDelegate:nil didEndSelector:nil contextInfo:nil];
		}
	}
	
	[popUpButton selectItemAtIndex:0];
}

- (void)setParametersString:(NSString*)aString
{
	[parametersString setString:aString];
}

- (void)setResultsString:(NSString*)aString
{
	[resultsString setString:aString];
}

- (void)setPopUpButton:(NSPopUpButton*)aPopUpButton
{
	popUpButton = aPopUpButton;
}

@end
