//
//  LifeTableDocument.h
//  PopBio
//
//  Created by Aaron Golden on 05/09/07.
//  Copyright Reed College 2007 . All rights reserved.
//

#import "PopBioDocument.h"
#import "Backend.h"
@class SimpleTableView;

@interface LifeTableDocument : PopBioDocument
{
	IBOutlet NSButton *stochasticButton;
    IBOutlet NSTextField *timePeriodsField;
	
	IBOutlet NSTableView *inputTableView;
	IBOutlet SimpleTableView *inputTableParent;
	IBOutlet NSTableColumn *pxerrColumn;
	IBOutlet NSTableColumn *mxerrColumn;
	
	NSData *inputTableMatrixData;
	
	int ageGroups;
	int timePeriods;
	int stochasticity;
	int randomSeed;
	
	int inputTableStochasticity;
}

- (NSString *)dataAsString;
@end

@interface LifeTableDocument(SimpleTableDataSourceDelegate)
- (void)didRemoveRowsFromTable:(NSTableView*)aTableView;
- (NSMutableArray *)newRowForTable:(NSTableView*)aTableView;
@end
