#import "LifeTableDataSource.h"

@interface LifeTableDataSource(Private)
- (NSMutableArray *)newRow;
@end

@implementation LifeTableDataSource(Private)

- (NSMutableArray *)newRow
{
	int x=0;
	if([dataArray count] > 0)
		x = [[[dataArray lastObject] objectAtIndex:0] intValue] + 1;
	
	return [NSMutableArray arrayWithObjects:
	[NSNumber numberWithInt:x], [NSNumber numberWithInt:0], [NSNumber numberWithDouble:1],
	[NSNumber numberWithDouble:0], [NSNumber numberWithDouble:0], [NSNumber numberWithDouble:0], nil];
}
@end

@implementation LifeTableDataSource

- (id)init
{
	[super init];
	dataArray = [[NSMutableArray alloc] init];
	NSMutableArray *newRow = [self newRow];
	[dataArray addObject:newRow];
	return self;
}

- (int)numberOfRows
{
	return [dataArray count];
}

- (NSString *)dataAsString
{
	int i, numRows = [dataArray count];
	if(numRows == 0)
		return nil;
	
	NSArray *row;
	NSMutableString *outputString = [[NSMutableString alloc] init];
	BOOL stochastic = [tableView isStochastic];

	int nx;
	double px, mx, pxerr, mxerr;

	for(i=0; i<numRows; i++)
	{
		row = [dataArray objectAtIndex:i];
		nx = [[row objectAtIndex:1] intValue];
		px = [[row objectAtIndex:2] doubleValue];
		mx = [[row objectAtIndex:4] doubleValue];
		
		if(!stochastic)
			[outputString appendFormat:@"%d %.2lf %.2lf ", nx, px, mx];
		else
		{
			pxerr = [[row objectAtIndex:3] doubleValue];
			mxerr = [[row objectAtIndex:5] doubleValue];
			[outputString appendFormat:@"%d %.2f %.2f %.2f %.2f ", nx, px, pxerr, mx, mxerr];
		}
	}
	
	return [NSString stringWithString:outputString];
}

- (NSData*)data
{
	NSMutableData *data = [[NSMutableData alloc] init];
	int count = [dataArray count];
	[data appendBytes:&count length:sizeof(int)];
	BOOL stochastic = [tableView isStochastic];
	[data appendBytes:&stochastic length:sizeof(bool)];
	
	int nx;
	double px, mx, pxerr, mxerr;
	int i;
	for(i=0; i<count; i++)
	{
		NSArray *row = [dataArray objectAtIndex:i];
		nx = [[row objectAtIndex:1] intValue];
		px = [[row objectAtIndex:2] doubleValue];
		mx = [[row objectAtIndex:4] doubleValue];
		
		if(!stochastic){
			[data appendBytes:&nx length:sizeof(int)];
			[data appendBytes:&px length:sizeof(double)];
			[data appendBytes:&mx length:sizeof(double)];
		}
		else
		{
			pxerr = [[row objectAtIndex:3] doubleValue];
			mxerr = [[row objectAtIndex:5] doubleValue];
			[data appendBytes:&nx length:sizeof(int)];
			[data appendBytes:&px length:sizeof(double)];
			[data appendBytes:&pxerr length:sizeof(double)];
			[data appendBytes:&mx length:sizeof(double)];
			[data appendBytes:&mxerr length:sizeof(double)];
		}
	}
	
	return data;
}

- (void)readData:(NSData*)data
{
	if(dataArray){
		[dataArray release];
		dataArray = nil;
	}
	dataArray = [[NSMutableArray alloc] init];
	int count, stochastic;
	memcpy(&count, [data bytes], sizeof(int));
	memcpy(&stochastic, [data bytes]+sizeof(int), sizeof(int));
	
	int nx;
	double px, mx, pxerr, mxerr;
	int offset = sizeof(int)*2;
	int i;
	for(i=0; i<count; i++)
	{
		if(!stochastic){
			memcpy(&nx, [data bytes]+offset, sizeof(int)); offset += sizeof(int);
			memcpy(&px, [data bytes]+offset, sizeof(double)); offset += sizeof(double);
			memcpy(&mx, [data bytes]+offset, sizeof(double)); offset += sizeof(double);
			[dataArray addObject:[NSArray arrayWithObjects:[NSNumber numberWithInt:nx],
				[NSNumber numberWithDouble:px], [NSNumber numberWithDouble:mx], nil]];
		}
		else
		{
			memcpy(&nx, [data bytes]+offset, sizeof(int)); offset += sizeof(int);
			memcpy(&px, [data bytes]+offset, sizeof(double)); offset += sizeof(double);
			memcpy(&pxerr, [data bytes]+offset, sizeof(double)); offset += sizeof(double);
			memcpy(&mx, [data bytes]+offset, sizeof(double)); offset += sizeof(double);
			memcpy(&mxerr, [data bytes]+offset, sizeof(double)); offset += sizeof(double);
			[dataArray addObject:[NSArray arrayWithObjects:[NSNumber numberWithInt:nx],
				[NSNumber numberWithDouble:px], [NSNumber numberWithDouble:pxerr],
				[NSNumber numberWithDouble:mx], [NSNumber numberWithDouble:mxerr], nil]];
		}
	}
}

- (void)renumberRows
{
	int i, numRows = [dataArray count];
	for(i=0; i<numRows; i++)
		[[dataArray objectAtIndex:i] replaceObjectAtIndex:0 withObject: [NSNumber numberWithInt:i]];
}

- (IBAction)addRow:(id)sender
{
	NSMutableArray *newRow = [self newRow];
	[dataArray addObject:newRow];
	[tableView reloadData];
}

- (IBAction)removeSelectedRows:(id)sender
{
	[dataArray removeObjectsAtIndexes:[tableView selectedRowIndexes]];
	[self renumberRows];
	[tableView reloadData];
}
@end

@implementation LifeTableDataSource (NSTableDataSource)

// return the number of rows
- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
  return [dataArray count];
}

// return the value of a single table cell
- (id) tableView:(NSTableView *) aTableView
  objectValueForTableColumn:(NSTableColumn *) aTableColumn row:(int) rowIndex
{
	int columnIndex = [[aTableColumn identifier] intValue];
	return [[dataArray objectAtIndex:rowIndex] objectAtIndex:columnIndex];
}

// set the value of a single table cell
- (void)tableView:(NSTableView *)aTableView	setObjectValue:(id)anObject
  forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	int columnIndex = [[aTableColumn identifier] intValue];
	[[dataArray objectAtIndex:rowIndex] replaceObjectAtIndex:columnIndex withObject:anObject];
}

@end
