#import "FineTunePanel.h"

#import "PopBioDocument.h"

@implementation FineTunePanel

- (id)init
{
	self = [super init];
	if(self) {
		integratorType = IntegratorTypeRungeKutta;
		pointStep = 0.1;
	}
	return self;
}

- (IBAction)fineTunePanelCancel:(id)sender
{
	[eulerButton setState:(integratorType==IntegratorTypeEuler)];
	[rungeKuttaButton setState:(integratorType==IntegratorTypeRungeKutta)];
	[pointStepTextField setDoubleValue:pointStep];

	[NSApp endSheet:self];
	[self orderOut:self];
}

- (IBAction)fineTunePanelOk:(id)sender
{
	if([pointStepTextField doubleValue] <= 0.0){
		NSBeginAlertSheet(@"Point Step must be positive",
			@"OK", nil, nil, nil, self,  nil,
			nil, nil, @"You must specify a positive Point Step in order to continue.");
		return;
	}

	integratorType = [integratorSelectionMatrix selectedRow];
	pointStep = [pointStepTextField doubleValue];

	[NSApp endSheet:self];
	[self orderOut:self];
}

- (IBAction)showFineTunePanel:(id)sender
{
	[NSApp beginSheet:self modalForWindow:[doc windowForSheet]
		modalDelegate:self didEndSelector:nil contextInfo:nil];
}

- (void)setIntegratorType:(int)type
{
	integratorType = type;
	[eulerButton setState:(integratorType==IntegratorTypeEuler)];
	[rungeKuttaButton setState:(integratorType==IntegratorTypeRungeKutta)];
}

- (void)setPointStep:(double)step;
{
	pointStep = step;
	[pointStepTextField setDoubleValue:pointStep];
}

- (int)integratorType; { return integratorType; }
- (double)pointStep; { return pointStep; }

@end
