/* FineTunePanel */

#import <Cocoa/Cocoa.h>

#import "IntegratorType.h"

@class PopBioDocument;

@interface FineTunePanel : NSPanel
{
	IntegratorType integratorType;
	double pointStep;

	IBOutlet NSMatrix *integratorSelectionMatrix;
    IBOutlet NSButtonCell *eulerButton;
    IBOutlet NSButtonCell *rungeKuttaButton;
    IBOutlet NSTextField *pointStepTextField;
	
	IBOutlet PopBioDocument *doc;
}
- (IBAction)fineTunePanelCancel:(id)sender;
- (IBAction)fineTunePanelOk:(id)sender;
- (IBAction)showFineTunePanel:(id)sender;

- (void)setIntegratorType:(int)type;
- (void)setPointStep:(double)step;
- (int)integratorType;
- (double)pointStep;
@end
