/*
 *  Evaluator.c
 *  PopBio
 *
 *  Created by Aaron Golden on 3/23/07.
 *  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include "Backend.h"

#define DEBUG 0

// We define the size of the random space here.
// Since we're going to mod and div by MAX_RANDOM*
// make sure it's an integer power of 2.
#define MAX_RANDOM_AS_INT 65536
#define MAX_RANDOM_AS_FLOAT 65536.0

double _randomDouble(void)
{
	return (double)(random() % MAX_RANDOM_AS_INT) / MAX_RANDOM_AS_FLOAT;
}

void sigHandler(int sig)
{
	exit(0);
}

int main(int argc, char *argv[])
{
	if(argc < 2){
		printf("USAGE: %s <experiment type> [experiment parameters]\n", argv[0]);
		return -1;
	}
	
	if(signal(SIGTERM, sigHandler) == SIG_ERR){
		printf("Error: Could not set up signal handler\n");
		return -2;
	}
	
	printf("EXPERIMENT_STARTING\n");
	int expType;
	sscanf(argv[1], "%d", &expType);
	if(expType == kExperimentTypePopGenetics){
		runPopGenetics(argc, argv);
	}
	else if(expType == kExperimentTypePopGrowth){
		runPopGrowth(argc, argv);
	}
	else if(expType == kExperimentTypeLifeTable){
		runLifeTable(argc, argv);
	}
	else if(expType == kExperimentTypeCompetition){
		runCompetition(argc, argv);
	}
	else if(expType == kExperimentTypePredatorPrey){
		runPredatorPrey(argc, argv);
	}
	printf("EXPERIMENT_DONE");
	
	return 0;
}

