//
//  CompetitionDocument.h
//  PopBio
//
//  Created by Aaron Golden on 05/09/07.
//  Copyright Reed College 2007 . All rights reserved.
//

#import "PopBioDocument.h"
#import "Backend.h"
#import "PlotView.h"
@class PlotViewPointSelectorTool;
@class FineTunePanel;

@interface CompetitionDocument : PopBioDocument
{
	IBOutlet NSTextField *timeIntervalsTextField;
	
	IBOutlet NSTextField *initialPopulation1TextField;
	IBOutlet NSTextField *rateOfIncrease1TextField;
	IBOutlet NSTextField *competitionCoefficient1TextField;
	IBOutlet NSTextField *carryingCapacity1TextField;

	IBOutlet NSTextField *initialPopulation2TextField;
	IBOutlet NSTextField *rateOfIncrease2TextField;
	IBOutlet NSTextField *competitionCoefficient2TextField;
	IBOutlet NSTextField *carryingCapacity2TextField;
	
	IBOutlet NSColorWell *colorWell1;
	IBOutlet NSColorWell *colorWell2;
	
	IBOutlet NSDrawer *initialPopulationPanelDrawer;
	IBOutlet NSButton *initialPopulationPanelButton;
	IBOutlet PlotView *initialPopulationPanelPlotView;
	IBOutlet PlotViewPointSelectorTool *initialPopulationPanelPointSelector;

	IBOutlet FineTunePanel *fineTunePanel;

	CompetitionParameters params;
	
	NSImage *_crosshairImage;
	NSDictionary *_populationResults;
	NSString *_parametersReport;
	NSString *_resultsReport;
}

- (IBAction)toggleInitialPopulationPanelDrawer:(id)sender;
- (void)mouseDownAtDataPoint:(NSPoint)dataPoint;
- (void)updateInitialPopulationPanelPlotView;
- (void)registerForNotifications;

@end

@interface CompetitionDocument(NSWindowNotifications)
- (void)windowWillClose:(NSNotification *)notification;
@end

@interface CompetitionDocument(NSDrawerDelegate)
- (void)drawerDidClose:(NSNotification *)notification;
@end