/*
 *  Competition.h
 *  PopBio
 *
 *  Created by Aaron Golden on 05/09/07.
 *  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
 *
 */

#ifndef __COMPETITION__
#define __COMPETITION__

#include "IntegratorType.h"

#define kModelTypeExponential 0
#define kModelTypeLogistic 1

#define kDistributionFixed 0
#define kDistributionUniform 1
#define kDistributionNormal 2

typedef struct ___CompetitionParameters{

	double timeIntervals;
	double initialPopulation1;
	double rateOfIncrease1;
	double competitionCoefficient1;
	double carryingCapacity1;
	double initialPopulation2;
	double rateOfIncrease2;
	double competitionCoefficient2;
	double carryingCapacity2;
	double epsilon;
	IntegratorType integratorType;
	double pointStep;
	int randomSeed;
} CompetitionParameters;

int runCompetition(int argc, char *argv[]);

#endif