//
//  AgeStructureView.h
//  PopBio
//
//  Created by Aaron Golden on 8/1/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import <Cocoa/Cocoa.h>

@interface AgeStructureView : NSView {

	IBOutlet NSTableView *tableView;
	IBOutlet NSButton *playPauseButton;
	IBOutlet NSSlider *slider;
	IBOutlet NSStepper *stepper;
	IBOutlet NSTextField *timePeriodsElapsedLabel;
	double time;
	NSMutableArray *resultsMatrix;
	
	NSThread *doPlayStructureResultsThread;

	NSMutableString *parametersString;
	NSMutableString *resultsString;
	NSPopUpButton *popUpButton;
}

- (IBAction)setTimeInAgeStructureResults:(id)sender;
- (IBAction)playAgeStructureResults:(id)sender;
- (IBAction)pauseAgeStructureResults:(id)sender;
- (IBAction)stepThroughAgeStructureResults:(id)sender;

- (IBAction)saveParametersAsText:(id)sender;
- (IBAction)saveResultsAsText:(id)sender;

- (void)setResultsMatrix:(NSArray*)aMatrix;
- (void)setParametersString:(NSString*)aString;
- (void)setResultsString:(NSString*)aString;
- (void)setPopUpButton:(NSPopUpButton*)aPopUpButton;

@end

@interface AgeStructureView(NSTableDataSource)

- (NSInteger)numberOfRowsInTableView:(NSTableView *)aTableView;
- (id)tableView:(NSTableView *) aTableView
	objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;

@end
