//
//  AccumulatorWindowController.h
//  PopBio
//
//  Created by Aaron Golden on 4/3/07.
//  This work is provided under the terms of the Educational Community License 1.0, a copy of which is included with the source code.
//

#import <Cocoa/Cocoa.h>

@class PlotView;

@interface AccumulatorWindowController : NSWindowController {
	IBOutlet NSTableView *plotTable;
	IBOutlet NSDrawer *plotDrawer;
	IBOutlet NSButton *plotShowHideButton;
	IBOutlet PlotView *plotView;
	
	NSDictionary *_plot;
	NSMutableArray *_curves;
}

- (IBAction)toggleShowPlotTable:(id)sender;

- (void)setPlot:(NSDictionary*)aPlot;
- (BOOL)hasPlot;

- (void)addCurve:(NSDictionary*)aCurve withName:(NSString*)aName;
- (void)removeCurve:(NSDictionary*)aCurve;
- (BOOL)hasCurve:(NSDictionary*)aCurve;

- (NSInteger)numberOfRowsInTableView:(NSTableView *)aTableView;
- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;
- (void)tableView:(NSTableView *)aTableView setObjectValue:(id)anObject forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;

- (IBAction)removeSelectedCurves:(id)sender;
- (IBAction)updatePlotHiliting:(id)sender;

@end

@interface AccumulatorWindowController (PlotViewColorDelegate)
- (NSColor*)overrideColorForCurveAtIndex:(int)j;
@end
